﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class PromotionDetails : BusinessBaseClass
    {

        public PromotionDetails()
        {

        }

        public PromotionDetails(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromotionDetailsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("PromotionDetailsID"));
            PromotionID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromotionID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("PromotionID"));
            ProductsID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ProductsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ProductsID"));
            PromoType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PromoType"));
            DiscountType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DiscountType"));
            Discount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Discount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Discount"));
            BuyingQty = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BuyingQty")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("BuyingQty"));
            DiscountQty = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DiscountQty")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("DiscountQty"));
            UserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public Guid PromotionID { get; set; }

        public Guid ProductsID { get; set; }

        public string PromoType { get; set; }

        public string DiscountType { get; set; }

        public decimal Discount { get; set; }

        public int BuyingQty { get; set; }

        public int DiscountQty { get; set; }

        public Guid UserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
